local ITEM = Clockwork.item:New();
ITEM.name = "Pack of Batteries";
ITEM.model = "models/items/battery.mdl";
ITEM.weight = 0.1;
ITEM.useText = "Charge";
ITEM.category = "Consumables"
ITEM.batch = 10;
ITEM.cost = 2;
ITEM.useSound = "npc/turret_floor/click1.wav";
ITEM.access = "v";
ITEM.business = true;
ITEM.description = "A packet of powerful and advanced batteries, they seem to be working.  They are marked with the Voltaic company logo.";
ITEM.uniqueID = "item_battery";


-- Called when a player uses the item.
function ITEM:OnUse(player, itemEntity)
	if (Clockwork.player:GetAction(player) != "die") then
		player:SetCharacterData("battery", 100);
	end;
end;

-- Called when a player drops the item.
function ITEM:OnDrop(player, position) end;

ITEM:Register();